<?php
/**
 * risk_scoring_cron.php
 * Background job to update member risk scores.
 * Run nightly via cron.
 */

// Adjust paths as necessary for your environment
include 'layouts/dbconn.php';
require_once 'classes/HealthRiskScorer.php';

echo "Starting Risk Scoring Job...<br>";

// Fetch active members
$sql = "SELECT member_id FROM members WHERE status = 'Active'";
$result = $conn->query($sql);

if ($result) {
    $scorer = new HealthRiskScorer($conn);
    $count = 0;

    while ($row = $result->fetch_assoc()) {
        $memberId = $row['member_id'];
        $resultData = $scorer->calculateMemberRisk($memberId);

        echo "Processed Member ID: $memberId - Score: {$resultData['score']}\n";
        $count++;
    }

    echo "Job Complete. Processed $count members.";
} else {
    echo "No members found or error: " . $conn->error;
}

$conn->close();
?>